<?php
require "serverApi.php";

require "../Connections.php";

require "../functions/server.php";
require "../functions/getTime.php";
require "../functions/get_names.php";
require "../functions/getUplink.php";
require "../functions/timezones.php";
require "../functions/get_all_servers.php";

require "../health/get/getDisksHealth.php";
require "../health/get/getCameraHealth.php";

require "../timezones/get/getTimeZones.php";

require "../adapters/get/getAdapters.php";

require "../users/get/getUsers.php";

require "../storage/get/getStorage.php";
require "../channels/delete/deleteChannels.php";

try {
   $api = new serverApi();
   $data = $api->run();
   if (isset($data)) {
      echo json_encode($data);
   }
} catch (Exception $e) {
   echo json_encode(["error" => $e->getMessage()]);
}
